Rem This is the sql creation script for the Pro*COBOL lobdemo1

connect scott/tiger;

set serveroutput on;

Rem Make sure database has no license_table floating around

drop table license_table;

Rem ABSTRACTION:
Rem A license table reduces the notion of a driver's license into three 
Rem distinct components - a unique social security number (sss), 
Rem a name (name), and a text summary of the information on the individual
Rem including his driving record, which can be arbitrarily long and may 
Rem contain comments and data regarding the person's driving ability.

Rem IMPLEMENTATION:
Rem Our implementation follows this abstraction

create table license_table(
  sss char(9),
  name varchar2(50),
  txt_summary clob);

insert into license_table 
        values('971517006', 'Dennis Kernighan', 
        'Wearing a Bright Orange Shirt');

insert into license_table 
        values('555001212', 'Eight H. Number', 
        'Driving Under the Influence');

insert into license_table 
        values('010101010', 'P. Doughboy', 
        'Impersonating An Oracle Employee');

insert into license_table
        values('555377012', 'Calvin N. Hobbes', 
        'Driving Under the Influence');

select count(*) from license_table;

Rem Commit to save
commit;
